<?php
/**
 * The template for displaying Category Archive pages.
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */

get_header(); ?>

<div id="store">

<?php
  $term = array_pop(get_the_terms($post->ID, 'add'));
  $term_p = $term->parent;
  if ( ! $term_p == 0 ){
    $term = array_shift(get_the_terms($post->ID, 'add'));
  }
?>

  <div id="pan">
    <a href="<?php bloginfo('url'); ?>/">HOME</a> > <a href="<?php bloginfo('url'); ?>/?post_type=store">店舗検索</a> > <?php echo esc_html($term->name); ?>
  </div>

  <div id="store_head">
    <h2><?php echo esc_html($term->name); ?></h2>
  </div> <!-- STORE_HEAD END  -->

<?php //--------------------------- ▼ kawai 変更/追記 2014.07.02 ?>

  <div id="store_search">
  <?php
    // 課題：カスタムフィールドが追加された場合は手動で追加しなければいけない...
    // get_post_custom_keys で 記事単位のカスタムフィールドは取得できそうなのでそちらを利用するのもありかも

    // - 施 術
    $services = array(
      'カウンセリング','フェイシャルエステ',
    );
    // - 商 品
    $items = array(
      'プラスキン','プラスキンエクストラ','リポイン','HO','リポルテ','ホワイトニック','モリオアクニカ',
      'ATP','マニュアン','サンノフ','エアリージョン','ブランディード','ネオ','ビオコンク',
      'ハーピュア','クレスト ホワイトニック','ノーエ','ビアンキープ','アクネ','ATPクレスト',
    );
  ?>
    <p class="store_search_title"><span>絞込検索</span></p>
    <form action="" method="post" class="store_search_form" name="store_search_form">
      <div>
        <p>施 術</p>
        <ul>
          <?php foreach($services as $sv){ ?>
            <li>
              <label>
                <?php if(isset($_POST['q']) && in_array($sv,$_POST['q'])){ $plus = ' checked="checked"'; } else { $plus = ''; } ?>
                <input type="checkbox" name="q[]" value="<?php echo $sv; ?>"<?php echo $plus; ?> /> <?php echo $sv; ?>
              </label>
            </li>
          <?php } ?>
        </ul>
      </div>
      <div>
        <p>取扱商品</p>
        <ul>
          <?php foreach($items as $iv){ ?>
          <li>
            <label>
              <?php if(isset($_POST['q']) && in_array($iv,$_POST['q'])){ $plus = ' checked="checked"'; } else { $plus = ''; } ?>
              <input type="checkbox" name="q[]" value="<?php echo $iv; ?>"<?php echo $plus; ?>  /> <?php echo $iv; ?>
            </label>
          </li>
          <?php } ?>
        </ul>
      </div>
    </form>
    <div class="store_search_btn">
      <a href="#">検索する</a>
    </div>
    <script>
      $(document).on('click','.store_search_btn a',function(e){
        e.preventDefault();
        $('.store_search_form').submit();
      });
    </script>
  </div><!-- #store_search End -->

  <div id="store_list">
  <?php
    $i = 1;
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

    $meta_query = array();
    if(isset($_POST['q']))
    {
      foreach($_POST['q'] as $q){

        // - キーの正規化
        if($q === 'フェイシャルエステ'){
          $key = 'サロン設置';
        } else if($q === 'プラスキンエクストラ'){
          $key = 'Pエクストラ';
        } else if($q === 'クレスト ホワイトニック'){
          $key = 'ホワイトニッククレスト';
        } else {
          $key = $q;
        }

        // - クエリ配列の生成
        $meta_query[] = array(
          'key' => $key,
          'value' => array(NULL,'×'),
          'compare' => 'NOT IN'
        );

      }
    }

    $args = array(
      'orderby' => 'meta_value',
      'order' => 'ASC',
      'post_type' => 'store',
      'taxonomy' => 'add',
      'term' => $term->name,
      'meta_key' => '住所ひらがな',
      'posts_per_page' => 100,
      'paged' => $paged,
      'meta_query' => $meta_query,
    );
    $data = query_posts($args);

    if($data){
  ?>
  <table border="0" cellspacing="0" cellpadding="0">
    <tr>
      <th>店名</th>
      <th>住所</th>
      <th>電話番号</th>
    </tr>
    <?php
      while ( have_posts() ) : the_post();
      $i++;
      if($i % 2 == 0){
    ?>
    <tr>
      <td class="store_name"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></td>
      <td><?php echo get_post_meta($post->ID,住所,TRUE); ?></td>
      <td><?php echo get_post_meta($post->ID,電話番号,TRUE); ?></td>
    </tr>
    <!-- ex_box end -->
    <?php }else{ ?>
      <tr>
        <td class="store_name list_02"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></td>
        <td class="list_02"><?php echo get_post_meta($post->ID,住所,TRUE); ?></td>
        <td class="list_02"><?php echo get_post_meta($post->ID,電話番号,TRUE); ?></td>
      </tr>
    <?php
        }
      endwhile;
      wp_reset_query();
    ?>
  </table>
  <?php } else { ?>
    <p>店舗が見つかりませんでした。</p>
  <?php
    } // if($data) End
  ?>
<?php //--------------------------- ▲ kawai 変更/追記 2014.07.02 ?>

</div><!-- SOTER LIST END -->
</div><!-- STORE END -->

<?php get_footer(); ?>
